<?php
class ModelExtensionModuleXGift extends Model {
    private $mtype;
    private $ext_path;
    public function __construct($registry) {
        parent::__construct($registry);
        $this->registry = $registry;
        $this->ocm = ($ocm = $this->registry->get('ocm_front')) ? $ocm : new OCM\Front($this->registry);
        $this->mtype = 'module';
        $this->ext_path = 'extension/module/xgift';
    }
    public function getCombinationDesc($offer_id) {
        $xcombination = $this->db->query("SELECT * FROM `" . DB_PREFIX . "xgift` WHERE tab_id = '" . $offer_id . "'")->row;
        $method_data = $xcombination['method_data'];
        $method_data = json_decode($method_data, true);
        $return = array(
            'title' => $method_data['title'],
            'desc' => $method_data['desc']
        );
        return $this->getSettingByLang($return);
    }
    private function getSettingByLang($setting) {
        $language_id = (int)$this->config->get('config_language_id');
        $lang_fields = array('title', 'desc');
        foreach ($lang_fields as $field) {
            $setting[$field] = isset($setting[$field][$language_id]) ? $this->ocm->html_decode($setting[$field][$language_id]) : '';
        }
        return $setting;
    }
    public function getCSS($xgift_box) {
        $css = '<style type="text/css">
                 .xg .fa-angle-down, .xg .fa-angle-up, .xg .increase, .xg .decrease{
                    visibility: hidden !important;
                 }
                 .xg button[type="submit"], .xg input[type="submit"],
                 .quick-checkout-wrapper tr.xg .input-group-btn button:first-child {
                    display: none !important;
                 }
                 .xc-suggestion {
                    padding: 10px 15px;
                 }
                 .xg-gift-qnty {
                    font-weight: bold;
                 }
              </style>';
        if ($xgift_box && $xgift_box['css']) {
            $css .= '<style type="text/css">'.$xgift_box['css'].'</style>';
        }
        $bg = '239dce';
        $color = 'ffffff';
        if ($xgift_box && $xgift_box['bg_color']) {
            $bg = ltrim($xgift_box['bg_color'], '#');
        }
        if ($xgift_box && $xgift_box['font_color']) {
            $color = ltrim($xgift_box['font_color'], '#');
        }
        $css .= '<style type="text/css">';
        $css .= '.ocm-popup-title {background: #' . $bg . ' !important; color: #' . $color . ' !important;}';
        $css .= '</style>';
        return $css;
    }
    public function getScript() {
        $xgift_status = $this->ocm->getConfig('xgift_status', $this->mtype);
        $xgift_box = $this->ocm->getConfig('xgift_box', $this->mtype);
        $html = '';
        $page = '';
        if ($this->ocm->isCheckoutPage()) {
            $page = 'checkout';
        } else if ($this->ocm->isCartPage()) {
            $page = 'cart';
        } else if ($this->ocm->isInfoPage()) {
            $page = 'information';
        }
        if (!isset($this->session->data['xgsr'])) {
            $this->session->data['xgsr'] = '';
        }
        $skipped = isset($this->session->data['xg_skip']);
        $order_id = isset($this->session->data['order_id']) ? $this->session->data['order_id'] : 0;
        if (isset($this->session->data['xg_skip']) && !$this->session->data['xg_skip'] && $order_id) {
            $this->session->data['xg_skip'] = $order_id;
        }
        // reset flag if order_id got changed
        if (isset($this->session->data['xg_skip']) && $order_id != $this->session->data['xg_skip']) {
            $skipped = false;
        }

        if ($xgift_status && !$skipped && in_array($page, array('cart', 'checkout', 'information'))) {
            $this->load->language($this->ext_path);
            if ($page == 'information') {
                $mode = 'inline';
            } else if (!empty($xgift_box['mode'])) {
                $mode = $xgift_box['mode'];
            } else {
                $mode = 'popup';
            }
            $this->load->language($this->ext_path);
            $_xgift = array(
                'url'         => 'index.php?route=extension/module/xgift',
                'page'        => $page,
                'suggestion'  => $this->session->data['xgsr'] !== $page || $mode == 'inline',
                'sync'        => true,
                'close'       => !empty($xgift_box['close']),
                'mode'        => $mode,
                'lang'        => array(
                    'close' => $this->language->get('text_skip_offer'),
                    'title' => $this->language->get('text_gift_title')
                )
            );
            $js = '<script type="text/javascript">';
            $js .= 'var _xgift ='.json_encode($_xgift).';';
            $js .= 'if (window.xgift && !window.xgift.is_init) {
                        window.xgift.setParams(_xgift);
                    }';
            $js .= '</script>';
            $html .= '<script src="catalog/view/javascript/xgift/xgift.min.js?v=2.0.4" defer type="text/javascript"></script>';
            $html .= $this->getCSS($xgift_box);
            $html .= $js;
            $this->session->data['xgsr'] = $page;
        }
        return $html;
    }
}