<?php

/**
 * @license Commercial
 * @author info@ocdemo.eu
 * 
 * All code within this file is copyright OC Mega Extensions.
 * You may not copy or reuse code within this file without written permission. 
 */

abstract class ModelModuleMRewardPointsAbstract extends Model {
	
	private $_name = 'mreward_points';
	
	private $data = array();
	
	protected function module_path() {
		/* @var $path string */
		$path = 'module/' . $this->_name;
		
		if( version_compare( VERSION, '3', '>=' ) ) {
			$path = 'extension/' . $path;
		}
		
		return $path;
	}
	
	public function saveSettings( $group, $data ) {		
		$this->load->model('setting/setting');
		
		$this->model_setting_setting->editSetting($group, array( $group => $data ));
	}
	
	public function install() {
		$this->addColumn( 'product', 'skip_rewards_generator', 'ENUM("0","1") NOT NULL DEFAULT "0"');
		
		$this->addColumn( 'product_discount', 'reward_points', 'varchar(255) DEFAULT NULL' );
		$this->addColumn( 'product_special', 'reward_points', 'varchar(255) DEFAULT NULL' );

		$this->load->model('setting/setting');
		
		$this->load->model( 'localisation/language' );
		
		$languages = $this->model_localisation_language->getLanguages();
		
		$this->data = array_merge( $this->data, $this->language->load( $this->module_path() ) );
		
		$notify_content			= array();
		
		foreach( $languages as $language){	
			$notify_content[	(int)$language['language_id']] = array('notify_title' => $this->data['text_inst_email_title_receiving_reward_points'], 'description' => $this->data['text_inst_email_desc_receiving_reward_points']);
		}
		
		// generator
		$this->model_setting_setting->editSetting( $this->_name.'_generator', array(
			$this->_name.'_generator'	=> array(
				'points'		=> '',
				'amount'		=> '100',
				'groups'		=> array(),
				'example_price'	=> '100',
			)
		));
		
		// general tab
		$this->model_setting_setting->editSetting( $this->_name.'_settings', 
			array( $this->_name.'_settings' => array(
				'order_status_add'		=> array('5'),
				/* add predefined languages */
				'notify_content'		=> $notify_content,
			))
		);
		
		//Update customer rewards table
		$this->addColumn( 'customer_reward', 'reason_code', 'VARCHAR(25) NOT NULL DEFAULT ""');
		$this->addColumn( 'customer_reward', 'rewards_reminder', 'tinyint(1) NOT NULL');
		
		//Reminder about product review
		$this->addColumn( 'order', 'product_review_reminder', 'tinyint(1) NOT NULL DEFAULT 0');
		$this->db->query( 'UPDATE `' . DB_PREFIX . 'order` SET product_review_reminder = 1' );
		
		$this->load->model('setting/setting');
		$this->load->model( 'localisation/language' );
		
		$languages = $this->model_localisation_language->getLanguages();
		
		$this->data = array_merge( $this->data, $this->language->load( $this->module_path() ) );

		$add_text_to_points	= array();
		$text_on_first_order = array();
		$text_on_registration = array();
		$text_on_newsletter	= array();
		$text_on_product_review = array();
		
		foreach( $languages as $language){
			$add_text_to_points[(int)$language['language_id']] = array('content' => $this->data['text_inst_text_to_number']);
			$text_on_first_order[(int)$language['language_id']] = array('content' => $this->data['text_inst_on_first_order']);
			$text_on_registration[(int)$language['language_id']] = array('content' => $this->data['text_inst_on_account_reg']);
			$text_on_newsletter[(int)$language['language_id']] = array('content' => $this->data['text_inst_on_newsletter_sub']);
			$text_on_product_review[(int)$language['language_id']] = array('content' => $this->data['text_inst_on_product_review']);
		}
		
		$settings = (array) $this->config->get( $this->_name . '_settings' );
		
		// general tab
		$this->model_setting_setting->editSetting( $this->_name . '_settings', 
				array( $this->_name . '_settings' => array(
					'order_status_add'		=> isset($settings['order_status_add']) ? $settings['order_status_add'] : '',
					'order_status_remove'	=> array(),
					'points_prefix'			=> '',
					'points_suffix'			=> '',
					'email_notification_status' => isset($settings['email_notification_status']) ? $settings['email_notification_status'] : '',
					
					/* add predefined languages */ 
					'add_text_to_points'	=> $add_text_to_points,
					'notify_content'		=> isset($settings['notify_content']) ? $settings['notify_content'] : '',
					
					'bold_points_number'	=> '0'
				))
		);
		// bonuses
		$this->model_setting_setting->editSetting( $this->_name . '_bonuses', 
				array( $this->_name . '_bonuses' => array(
					'on_first_order'		=> '0',
					'on_registration'		=> '0',
					'on_newsletter'			=> '0',
					'newsletter_unsub'		=> '0',
					'on_product_review'		=> '0',
					'product_review_limit'	=> '10',
					'auto_approve_reviews'	=> '0',
					'text_on_first_order'	=> $text_on_first_order,
					'text_on_registration'	=> $text_on_registration,
					'text_on_newsletter'	=> $text_on_newsletter,
					'text_on_product_review'=> $text_on_product_review,
				))
		);
		
		// expiry reminder
		$this->model_setting_setting->editSetting( $this->_name . '_expiry_reminder', array(
			$this->_name . '_expiry_reminder'	=> array(
				'reminder_days_delayed' => '0',
				'cron_status'			=> '0',
				'reminder_status'		=> '0',
				'reminder_days_lose' => '7',
				'reminder_days_interval' => '3', 
			)
		));
		
		// review reminder
		$this->model_setting_setting->editSetting( $this->_name . '_reminder', 
			array( $this->_name . '_reminder' => array(
				 'cron_status'					=> '0',
				 'reminder_status'				=> '0',
				 'reminder_date_type'			=> '0',
				 'reminder_days_delayed'		=> '30',
				 'grouping_pending_reminders' => '1'
			))
		);
	}
	
	public function pendingReminders() {
		/* @var $settings array */
		$settings = $this->config->get( $this->_name.'_reminder' );

		if( ! empty( $settings['order_status_send_ids'] ) ) {
			/* @var $reminder_days_delayed int */
			$reminder_days_delayed = isset( $settings['reminder_days_delayed'] ) ? (int) $settings['reminder_days_delayed'] : 0;
			
			/* @var $date_type string */
			$date_type = isset( $settings['reminder_date_type'] ) && $settings['reminder_date_type'] ? 'date_added' : 'date_modified';
			
			/* @var $for_orders_created_after string */
			$for_orders_created_after = ! empty( $settings['for_orders_created_after'] ) ? $settings['for_orders_created_after'] : null;
			
			/* @var $sql string */
			$sql = "
				SELECT 
					COUNT(*) AS `total` 
				FROM 
					`" . DB_PREFIX . "order`
				WHERE 
					`product_review_reminder` = 0 
						AND 
					DATE( DATE_ADD(`" . $date_type . "`, INTERVAL " . $reminder_days_delayed . " DAY)) <= CURDATE() 
						AND 
					`order_status_id` IN (" . implode(',', $settings['order_status_send_ids']) . ")";
			
			if( $for_orders_created_after ) {
				$sql .= "
					AND `date_added` >= '" . $this->db->escape( $for_orders_created_after ) . "'
				";
			}

			return $this->db->query( $sql )->row['total'];
		} else {
			return 'error';
		}
	}

	public function sendTestEmail($testEmail, $from) {
		$lang = (int)$this->config->get('config_language_id');
		
		if( $from == 'review' ){
			$settings = $this->config->get( $this->_name.'_reminder' );
			$find = array(
				'{order_id}',
				'{review_bonus_points}',
				'{review_limit}',
				'{first_name}',
				'{last_name}'
			);
			$replaceTo = array(
				'test-order_id',
				'test-review_bonus_points',
				'test-review_limit',
				'test-first_name',
				'test-last_name'
			);
			$subject = $settings['reminder_content'][$lang]['reminder_title'];
			$message = $settings['reminder_content'][$lang]['description'];
			$message = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replaceTo, $message))));
		}elseif( $from == 'points' ){
			$settings = $this->config->get( $this->_name.'_expiry_reminder' );
			$reminder['order_ids'] = array('example-1', 'example-2');
			$reminder['points'] = 'example-0';
			$subject = $settings['reminder_content'][$lang]['reminder_title'];
			$message = $settings['reminder_content'][$lang]['description'];
			$message = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace(array('{order_ids}', '{amount_of_points}'), array('#'.implode(", #", $reminder['order_ids']), $reminder['points']), $message))));

		}
		
		if( version_compare( VERSION, '3', '>=' ) ) {
			$mail = new Mail($this->config->get('config_mail_engine'));
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
			$mail->smtp_username = $this->config->get('config_mail_smtp_username');
			$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
			$mail->smtp_port = $this->config->get('config_mail_smtp_port');
			$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
		} else if( null != ( $config_mail = $this->config->get('config_mail') ) && is_array( $config_mail ) && isset( $config_mail['protocol'] ) ) {
			$mail = new Mail($this->config->get('config_mail'));
		} else {
			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname')?$this->config->get('config_mail_smtp_hostname'):$this->config->get('config_mail_smtp_host');
			$mail->smtp_username = $this->config->get('config_mail_smtp_username');
			$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
			$mail->smtp_port = $this->config->get('config_mail_smtp_port');
			$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
		}

		$mail->setTo($testEmail);
		$mail->setFrom($this->config->get('config_email'));
		$mail->setSender(html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));
		$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
		$mail->setHtml(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
		$mail->send();
	}
	
	public function update( $install = false, $prev_ver = null, $new_ver = null ) {
		if( ! $install && ! is_null( $prev_ver ) && ! is_null( $new_ver ) ) {
			if( 
				( 
					version_compare( VERSION, '3', '<' )
						&&
					version_compare( $prev_ver, '2.1.0', '<' ) 
				)
					||
				(
					version_compare( VERSION, '3', '>=' )
						&&
					version_compare( $prev_ver, '3.0.5', '<' )
				)
			) {
				/* @var $path string */
				$path = 'module';
				
				/* @var $ext string */
				$ext = 'tpl';

				if( version_compare( VERSION, '3', '>=' ) ) {
					$path = 'extension/' . $path;
					$ext = 'twig';
				}
				
				/* @var $files_to_remove array */
				$files_to_remove = array(
					DIR_APPLICATION . 'model/' . $path . '/mreward_points_plus.php',
					
					DIR_APPLICATION . 'view/template/' . $path . '/plus_bonuses_points_on_actions_tab.' . $ext,
					DIR_APPLICATION . 'view/template/' . $path . '/plus_expiry_reminder.' . $ext,
					DIR_APPLICATION . 'view/template/' . $path . '/plus_general_settings_tab.' . $ext,
					DIR_APPLICATION . 'view/template/' . $path . '/plus_reminder.' . $ext,
					
					DIR_SYSTEM . 'library/mreward_points/helper_plus.php',
					DIR_SYSTEM . 'library/mreward_points/plus.php',
					DIR_SYSTEM . 'library/mreward_points/activate.php',
					DIR_SYSTEM . 'library/mreward_points/default.php',
					
					DIR_SYSTEM . 'mreward_points_plus.ocmod.xml',
				);
				
				/* @var $file string */
				foreach( $files_to_remove as $file ) {
					if( file_exists( $file ) && is_file( $file ) && is_readable( $file ) && is_writable( $file ) ) {
						unlink( $file );
					}
				}
			}
		}
		
		if( 
			$install 
				||
			( 
				! is_null( $prev_ver ) 
					&& 
				(	
					( 
						version_compare( VERSION, '3', '<' )
							&&
						version_compare( $prev_ver, '2.1.0', '<' ) 
					)
						||
					(
						version_compare( VERSION, '3', '>=' )
							&&
						version_compare( $prev_ver, '3.0.1', '<=' )
					)
				)
			)
		) {
			$this->addColumn( 'product_discount', 'reward_points', 'varchar(255) DEFAULT NULL' );
			$this->addColumn( 'product_special', 'reward_points', 'varchar(255) DEFAULT NULL' );
		}
		
		// @since 2.1.0
		// @since 3.0.3
		if( 
			$install 
				||
			( 
				! is_null( $prev_ver ) 
					&& 
				(	
					( 
						version_compare( VERSION, '3', '<' )
							&&
						version_compare( $prev_ver, '2.1.0', '<' ) 
					)
						||
					(
						version_compare( VERSION, '3', '>=' )
							&&
						version_compare( $prev_ver, '3.0.3', '<' )
					)
				)
			)
		) {
			$this->addColumn( 'customer_reward', 'expired', 'TINYINT(1) NOT NULL DEFAULT "0"' );
		}
	}
	
	public function uninstall() {		
		$this->removeColumn( 'product', 'skip_rewards_generator' );
		
		$this->removeColumn( 'product_discount', 'reward_points' );
		$this->removeColumn( 'product_special', 'reward_points' );
		
		$this->removeColumn( 'customer_reward', 'reason_code' );
		$this->removeColumn( 'customer_reward', 'rewards_reminder' );
		$this->removeColumn( 'order', 'product_review_reminder' );
		
		// @since 2.1.0
		// @since 3.0.3
		$this->removeColumn( 'customer_reward', 'expired' );
		
		/* @var $keys array */
		$keys = array(
			'mreward_points_generator',
			'mreward_points_settings',
			'mreward_points_installed',
			'mreward_points_version',
			'mreward_points_license',
			'mreward_points_plus_version',
			'mreward_points_bonuses',
			'mreward_points_expiry_reminder',
			'mreward_points_reminder',
			'mreward_points_plus_installed',
			'mreward_points_plus_version',
			'reward_cron_send_expiry_reminders',
			'reward_cron_send_expiry_reminders',
		);
		
		$this->db->query("DELETE FROM `" . DB_PREFIX . "setting` WHERE `key` IN('".implode("','", $keys)."')");
	}
		
	/**
	 * Add column to table
	 * 
	 * @param string $table
	 * @param string $column
	 * @param string $type
	 * @return boolean 
	 */
	public function addColumn( $table, $column, $type ) {		
		$query = $this->db->query('SHOW COLUMNS FROM `' . DB_PREFIX . $table . '` LIKE "' . $column . '"');
		
		if( ! $query->num_rows ) {
			$this->db->query( 'ALTER TABLE `' . DB_PREFIX . $table . '` ADD `' . $column . '` ' . $type );
			
			return true;
		}
		
		return false;
	}
		
	/**
	 * Remove column from table
	 * 
	 * @param string $table
	 * @param string $column
	 * @return bool 
	 */
	public function removeColumn( $table, $column ) {		
		$query = $this->db->query('SHOW COLUMNS FROM `' . DB_PREFIX . $table . '` LIKE "' . $column . '"');
		
		if( $query->num_rows ) {
			$this->db->query('ALTER TABLE `' . DB_PREFIX . $table . '` DROP `' . $column . '`');
			
			return true;
		}
		
		return false;
	}
	
}