<?php
class ControllerExtensiontmdtab extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/tmdtab');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/tmdtab');

		$this->getList();
	}
	public function add() {
		$this->load->language('extension/tmdtab');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('extension/tmdtab');
		if (($this->request->server['REQUEST_METHOD'] == 'POST')&& $this->validateForm()) {
			$this->model_extension_tmdtab->addtmdtab($this->request->post);
			$this->session->data['success'] = $this->language->get('text_success');
			$url = '';
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}
			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			$this->response->redirect($this->url->link('extension/tmdtab', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}
		$this->getForm();
	}
	
	public function edit() {
		$this->load->language('extension/tmdtab');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('extension/tmdtab');
		if (($this->request->server['REQUEST_METHOD'] == 'POST')&& $this->validateForm()) {
			$this->model_extension_tmdtab->edittmdtab($this->request->get['tmdtab_id'], $this->request->post);
			$this->session->data['success'] = $this->language->get('text_success');
			$url = '';
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}
			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			$this->response->redirect($this->url->link('extension/tmdtab', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}
	
	public function delete() {
		$this->load->language('extension/tmdtab');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('extension/tmdtab');
		if (isset($this->request->post['selected'])) {
			foreach ($this->request->post['selected'] as $tmdtab_id) {
				$this->model_extension_tmdtab->deletetmdtab($tmdtab_id);
			}
			$this->session->data['success'] = $this->language->get('text_success');
			$url = '';
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}
			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			$this->response->redirect($this->url->link('extension/tmdtab', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}
		$this->getList();
	}
	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 't.sort_order';
		}
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$url = '';

		if ($order == 'DESC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}
		

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/tmdtab', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('extension/tmdtab/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('extension/tmdtab/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

 	$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);
		$data['tmdtabs']= array();	
		$tmdtab_total = $this->model_extension_tmdtab->getTotaltmdtab();

		$results = $this->model_extension_tmdtab->gettmdtabs($filter_data);
		//echo "<pre>";
		//print_r($results);die();

		foreach ($results as $result) {
			$data['tmdtabs'][] = array(
				'tmdtab_id' => $result['tmdtab_id'],
				'title'          => $result['title'],
				'description' 	   => utf8_substr(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')), 0, 125).'....',
				'sort_order'     => $result['sort_order'],
				'edit'           => $this->url->link('extension/tmdtab/edit', 'user_token=' . $this->session->data['user_token'] . '&tmdtab_id=' . $result['tmdtab_id'] . $url, true)
			);
		}
		$data['heading_title'] = $this->language->get('heading_title');
		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_confirm'] = $this->language->get('text_confirm');
		$data['column_title'] = $this->language->get('column_title');
		$data['column_sort_order'] = $this->language->get('column_sort_order');
		$data['column_action'] = $this->language->get('column_action');
		$data['column_description'] = $this->language->get('column_description');
		$data['button_add'] = $this->language->get('button_add');
		$data['button_edit'] = $this->language->get('button_edit');
		$data['button_delete'] = $this->language->get('button_delete');
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}
		$data['sort_title'] = $this->url->link('extension/tmdtab', 'user_token=' . $this->session->data['user_token'] . '&sort=td.title' . $url, true);
		$data['sort_sort_order'] = $this->url->link('extension/tmdtab', 'user_token=' . $this->session->data['user_token'] . '&sort=t.sort_order' . $url, true);
		$data['sort_description'] = $this->url->link('extension/tmdtab', 'user_token=' . $this->session->data['user_token'] . '&sort=td.description' . $url, true);
		$pagination = new Pagination();
		$pagination->total = $tmdtab_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('extension/tmdtab', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);
		$data['pagination'] = $pagination->render();
		$data['results'] = sprintf($this->language->get('text_pagination'), ($tmdtab_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($tmdtab_total - $this->config->get('config_limit_admin'))) ? $tmdtab_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $tmdtab_total, ceil($tmdtab_total / $this->config->get('config_limit_admin')));
		$data['sort'] = $sort;
		$data['order'] = $order;
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		$this->response->setOutput($this->load->view('extension/tmdtab_list', $data));
	}
	protected function getForm() {
		$this->load->language('extension/tmdtab');
		$data['heading_title'] = $this->language->get('heading_title');
		$data['text_form'] = !isset($this->request->get['tmdtab_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
		$data['text_default'] = $this->language->get('text_default');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['entry_title'] = $this->language->get('entry_title');
		$data['column_description'] = $this->language->get('column_description');
		$data['entry_meta_title'] = $this->language->get('entry_meta_title');
		$data['entry_meta_description'] = $this->language->get('entry_meta_description');
		$data['entry_meta_keyword'] = $this->language->get('entry_meta_keyword');
		$data['entry_keyword'] = $this->language->get('entry_keyword');
		$data['entry_store'] = $this->language->get('entry_store');
		$data['entry_bottom'] = $this->language->get('entry_bottom');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_layout'] = $this->language->get('entry_layout');
		// 20-12-2018
		$data['entry_device'] 			= $this->language->get('entry_device');
		$data['entry_customer_group'] 	= $this->language->get('entry_customer_group');
		// 20-12-2018
		$data['help_keyword'] = $this->language->get('help_keyword');
		$data['help_bottom'] = $this->language->get('help_bottom');
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		$data['tab_general'] = $this->language->get('tab_general');
		$data['tab_data'] = $this->language->get('tab_data');
		// 20-12-2018
		$data['tab_setting'] 			= $this->language->get('tab_setting');
		// 20-12-2018
		$data['entry_product'] = $this->language->get('entry_product');
		$data['text_none'] = $this->language->get('text_none');
		$data['text_none'] = $this->language->get('text_none');
		$data['tab_link'] = $this->language->get('Link');
		$data['entry_manufacturer'] = $this->language->get('entry_manufacturer');
		$data['entry_category'] = $this->language->get('entry_category');
		$data['entry_description'] = $this->language->get('entry_description');
		// 20-12-2018
		$data['text_form'] 				= !isset($this->request->get['tmdtab_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
		$data['text_default'] 			= $this->language->get('text_default');
		$data['text_enabled'] 			= $this->language->get('text_enabled');
		$data['text_disabled'] 			= $this->language->get('text_disabled');
		$data['text_phone'] 			= $this->language->get('text_phone');
		$data['text_tablet'] 			= $this->language->get('text_tablet');
		$data['text_desktop'] 			= $this->language->get('text_desktop');
		$data['text_all']	 			= $this->language->get('text_all');
		$data['text_customer']			= $this->language->get('text_customer');
		$data['text_guest']	 			= $this->language->get('text_guest');
		// 20-12-2018
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['title'])) {
			$data['error_title'] = $this->error['title'];
		} else {
			$data['error_title'] = array();
		}

		if (isset($this->error['description'])) {
			$data['error_description'] = $this->error['description'];
		} else {
			$data['error_description'] = array();
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$data['product_categories'] = array();
		if(isset($categories)){
		foreach ($categories as $category_id) {
			$category_info = $this->model_catalog_category->getCategory($category_id);
			if ($category_info) {
				$data['product_categories'][] = array(
				'category_id' => $category_info['category_id'],
				'name'        => ($category_info['path']) ? $category_info['path'] . ' &gt; ' . $category_info['name'] : $category_info['name']
			);
			}
		}
		}
			$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/tmdtab', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['tmdtab_id'])) {
			$data['action'] = $this->url->link('extension/tmdtab/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('extension/tmdtab/edit', 'user_token=' . $this->session->data['user_token'] . '&tmdtab_id=' . $this->request->get['tmdtab_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('extension/tmdtab', 'user_token=' . $this->session->data['user_token'] . $url, true);


		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();

		if (isset($this->request->get['tmdtab_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$tmdtab_info = $this->model_extension_tmdtab->gettmdtab($this->request->get['tmdtab_id']);
		}
		
		
		$data['user_token'] = $this->session->data['user_token'];
	
		if (isset($this->request->post['tmdtab_description'])) {
			$data['tmdtab_description'] = $this->request->post['tmdtab_description'];
		} elseif (isset($this->request->get['tmdtab_id'])) {
			$data['tmdtab_description'] = $this->model_extension_tmdtab->gettmdtabDescriptions($this->request->get['tmdtab_id']);
		} else {
			$data['tmdtab_description'] = array();
		}
		
		if (isset($this->request->post['category_id'])){
			$category_ids = $this->request->post['category_id'];
		}elseif (!empty($tmdtab_info)){
			$category_ids = $this->model_extension_tmdtab->gettmdchatcategoryid($this->request->get['tmdtab_id']);
		} else{
			$category_ids = '';
		}
	    $data['categories']=array();
		$this->load->model('catalog/category');
		if(!empty($category_ids)){
			foreach($category_ids as $category_id){
				$category_info=$this->model_catalog_category->getCategory($category_id);
				///subcategory//
				if(!empty($category_info['path'])){
					$category=$category_info['path'].' > '.$category_info['name'];
				}else{
					$category=$category_info['name'];
				}
				///subcategory//
				$data['categories'][]=array(
					'category_id'=>$category_id,
					'name'=>$category	,
				);
				
			}
		}
		
		
		//manufacturer_id//
		if (isset($this->request->post['manufacturer_id'])){
			$manufacturers = $this->request->post['manufacturer_id'];
		}elseif (!empty($tmdtab_info)){
			$manufacturers = $this->model_extension_tmdtab->gettmdchatmanufacturer($this->request->get['tmdtab_id']);
		} else{
			$manufacturers = '';
		}
	    $data['manufacturerss']=array();
		$this->load->model('catalog/manufacturer');
		if(!empty($manufacturers)){
			foreach($manufacturers as $manufacturer_id){
				$manufacturers_info=$this->model_catalog_manufacturer->getManufacturer($manufacturer_id);
				///subcategory//
				
				$data['manufacturerss'][]=array(
					'manufacturer_id'	=>$manufacturer_id,
					'name'				=>$manufacturers_info['name'],
				);
				
			}
		}
        
        //product_id//
		if (isset($this->request->post['product_id'])){
			$products = $this->request->post['product_id'];
		}elseif (!empty($tmdtab_info)){
			$products = $this->model_extension_tmdtab->gettmdchatproduct($this->request->get['tmdtab_id']);
		} else{
			$products = '';
		}
	    $data['productss']=array();
		$this->load->model('catalog/product');
		if(!empty($products)){
			foreach($products as $product_id){
				$products_info=$this->model_catalog_product->getProduct($product_id);
				///subcategory//
				
				$data['productss'][]=array(
					'product_id' 	=>$product_id,
					'name' 			=>$products_info['name'],
				);
				
			}
		}
		//manufacturer_id//
		
		// 20-12-2018
		$this->load->model('customer/customer_group');
		$data['customergroup'] = $this->model_customer_customer_group->getCustomerGroups();

		if (isset($this->request->post['customer_group'])) {
			$data['customer_group'] = $this->request->post['customer_group'];
		} elseif (isset($this->request->get['tmdtab_id'])) {
			$data['customer_group'] = $this->model_extension_tmdtab->getTmdTabCustomerGroup($this->request->get['tmdtab_id']);
		} else {
			$data['customer_group'] = array(0);
		}
		// 20-12-2018

		// 20-12-2018
		$this->load->model('setting/store');
		$data['stores'] =  $this->model_setting_store->getStores();

		if (isset($this->request->post['tmdtab_store'])) {
			$data['tmdtab_store'] = $this->request->post['tmdtab_store'];
		} elseif (isset($this->request->get['tmdtab_id'])) {
			$data['tmdtab_store'] = $this->model_extension_tmdtab->getTmdTabStore($this->request->get['tmdtab_id']);
		} else {
			$data['tmdtab_store'] = array(0);
		}
		// 20-12-2018
		
		
		if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (!empty($tmdtab_info)) {
			$data['status'] = $tmdtab_info['status'];
		} else {
			$data['status'] = true;
		}

		if (isset($this->request->post['sort_order'])) {
			$data['sort_order'] = $this->request->post['sort_order'];
		} elseif (!empty($tmdtab_info)) {
			$data['sort_order'] = $tmdtab_info['sort_order'];
		} else {
			$data['sort_order'] = '';
		}

		// 20-12-2018
		if (isset($this->request->post['device'])) {
			$data['device'] = $this->request->post['device'];
		} elseif (!empty($tmdtab_info)) {
			$data['device'] =unserialize($tmdtab_info['device']);
		} else {
			$data['device'] = array();
		}

		if (isset($this->request->post['customer'])) {
			$data['customer'] = $this->request->post['customer'];
		} elseif (!empty($tmdtab_info)) {
			$data['customer'] = $tmdtab_info['customer'];
		} else {
			$data['customer'] = '';
		}
		// 20-12-2018
		
		

		$this->load->model('design/layout');

		$data['layouts'] = $this->model_design_layout->getLayouts();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/tmdtab_form', $data));
	}
	
		////   validateDelete  ////
	
	
	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'extension/tmdtab')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		foreach ($this->request->post['tmdtab_description'] as $language_id => $value) {
			if ((utf8_strlen($value['title']) < 3) || (utf8_strlen($value['title']) > 64)) {
				$this->error['title'][$language_id] = $this->language->get('error_title');
			}

			if (utf8_strlen($value['description']) < 3) {
				$this->error['description'][$language_id] = $this->language->get('error_description');
			}

			
		}

		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;
	}


	
}