<?php
class ControllerExtensionModuleDisableAddtocart extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/module/disable_addtocart');

		$this->document->setTitle(strip_tags($this->language->get('heading_title')));

		$this->load->model('setting/setting');
		
		if(isset($this->request->get['store_id'])) {
			$data['store_id'] = $this->request->get['store_id'];
		}else{
			$data['store_id']	= 0;
		}

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('module_disable_addtocart', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');
			if($this->request->post['stay']==1){
				$this->response->redirect($this->url->link('extension/module/disable_addtocart', '&store_id='.$data['store_id'].'&user_token=' . $this->session->data['user_token'] , true));
			}else{
				$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
			}
		}

		$data['heading_title'] = strip_tags($this->language->get('heading_title'));

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_default'] = $this->language->get('text_default');

		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_button_label'] = $this->language->get('entry_button_label');
		$data['tab_general'] = $this->language->get('tab_general');
		$data['tab_language'] = $this->language->get('tab_language');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		
		$data['help_button_label'] = $this->language->get('help_button_label');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => strip_tags($this->language->get('heading_title')),
			'href' => $this->url->link('extension/module/disable_addtocart', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/module/disable_addtocart', 'user_token=' . $this->session->data['user_token'], true);
		
		$data['store_action'] =  $this->url->link('extension/module/disable_addtocart','user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);
		
		$store_info = $this->model_setting_setting->getSetting('module_disable_addtocart', $data['store_id']);

		if (isset($this->request->post['module_disable_addtocart_status'])) {
			$data['module_disable_addtocart_status'] = $this->request->post['module_disable_addtocart_status'];
		}elseif(isset($store_info['module_disable_addtocart_status'])){
		    $data['module_disable_addtocart_status'] = $store_info['module_disable_addtocart_status'];
		}else{
			$data['module_disable_addtocart_status'] = $this->config->get('module_disable_addtocart_status');
		}
		
		if (isset($this->request->post['module_disable_addtocart_out_stock_status'])) {
			$data['module_disable_addtocart_out_stock_status'] = $this->request->post['module_disable_addtocart_out_stock_status'];
		}elseif(!empty($store_info['module_disable_addtocart_out_stock_status'])){
		    $data['module_disable_addtocart_out_stock_status'] = $store_info['module_disable_addtocart_out_stock_status'];
		}else{
			$data['module_disable_addtocart_out_stock_status'] = array();
		}
		
		$this->load->model('localisation/language');
		$languages = $this->model_localisation_language->getLanguages();
		
		foreach ($languages as $language) {
			if (isset($this->request->post['module_disable_addtocart_button_label' . $language['language_id']])) {
				$data['module_disable_addtocart_button_label'][$language['language_id']] = $this->request->post['module_disable_addtocart_button_label' . $language['language_id']];
			} elseif(isset($store_info['module_disable_addtocart_button_label'. $language['language_id']])){
				$data['module_disable_addtocart_button_label'][$language['language_id']] = $store_info['module_disable_addtocart_button_label'. $language['language_id']];
			} else {
				$data['module_disable_addtocart_button_label'][$language['language_id']] = '';
			}
		}

		$data['languages'] = $languages;
		
		
		$this->load->model('setting/store');
		$data['stores'] = $this->model_setting_store->getStores();
		
		$this->load->model('localisation/stock_status');
		$data['stock_statuses'] = $this->model_localisation_stock_status->getStockStatuses();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/disable_addtocart', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/disable_addtocart')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}