<?php
class ModelExtensiontmdtab extends Model {
	public function install() {
		
$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."tmd_custom_tab` (
  `tmdtab_id` int(10) NOT NULL AUTO_INCREMENT,
  `status` int(100) NOT NULL,
  `sort_order` int(100) NOT NULL,
  `device` text NOT NULL,
  `customer` int(11) NOT NULL,
  `date_added` date NOT NULL,
  `date_modified` date NOT NULL,
  PRIMARY KEY (`tmdtab_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."tmd_custom_tab_category` (
  `category_id` int(250) NOT NULL,
  `tmdtab_id` int(250) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."tmd_custom_tab_customer_group` (
  `tmdtab_id` int(11) NOT NULL,
  `customer_group_id` int(11) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."tmd_custom_tab_description` (
  `tmdtab_description_id` int(100) NOT NULL AUTO_INCREMENT,
  `tmdtab_id` int(100) NOT NULL,
  `description` text NOT NULL,
  `title` varchar(250) NOT NULL,
  `language_id` int(11) NOT NULL,
  `date_added` date NOT NULL,
  `date_modified` date NOT NULL,
  PRIMARY KEY (`tmdtab_description_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."tmd_custom_tab_manufacturer` (
  `tmdtab_id` int(100) NOT NULL,
  `manufacturer_id` int(100) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."tmd_custom_tab_product` (
  `product_id` int(11) NOT NULL,
  `tmdtab_id` int(11) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."tmd_custom_tab_store` (
  `tmdtab_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."product_customtab` (
  `product_customtab_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_customtab_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."product_customtab_description` (
  `product_customtab_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `title` varchar(255) CHARACTER SET utf8 NOT NULL,
  `description` text CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");

	}
	public function uninstall() {
	$this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."tmd_custom_tab`");	
	$this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."tmd_custom_tab_category`");
    $this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."tmd_custom_tab_customer_group`");
	$this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."tmd_custom_tab_description`");
	$this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."tmd_custom_tab_manufacturer`");
	$this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."tmd_custom_tab_product`");
	$this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."tmd_custom_tab_store`");
	$this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."product_customtab`");
	$this->db->query("DROP TABLE IF EXISTS `".DB_PREFIX."product_customtab_description`");
	}
	
	public function addtmdtab($data) {
		$device='';

			if(isset($data['device'])){

				$device=serialize($data['device']);

			}
		$this->db->query("INSERT INTO " . DB_PREFIX . "tmd_custom_tab SET sort_order = '" . (int)$data['sort_order'] . "',status = '" . (int)$data['status'] . "',device = '".$device. "',customer = '" . (int)$data['customer'] . "',date_added=now()");

		$tmdtab_id = $this->db->getLastId();

		foreach ($data['tmdtab_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "tmd_custom_tab_description SET tmdtab_id = '" . (int)$tmdtab_id . "', language_id = '" . (int)$language_id . "', title = '" . $this->db->escape($value['title']) . "',description = '" . $this->db->escape($value['description']) . "',date_added=now()");
		}

		if (isset($data['category_id'])){
			foreach ($data['category_id'] as $category_id){
				$sql = $this->db->query("INSERT INTO " . DB_PREFIX . "tmd_custom_tab_category SET tmdtab_id = '" . (int) $tmdtab_id . "',category_id='" . $category_id . "'");
			}
		}
		
		if (isset($data['manufacturer_id'])){
			foreach ($data['manufacturer_id'] as $manufacturer_id){
				$sql = $this->db->query("INSERT INTO " . DB_PREFIX . "tmd_custom_tab_manufacturer SET tmdtab_id = '" . (int) $tmdtab_id . "',manufacturer_id='" . $manufacturer_id . "'");
			}
		}
		if (isset($data['product_id'])){
			foreach ($data['product_id'] as $product_id){
				$sql = $this->db->query("INSERT INTO " . DB_PREFIX . "tmd_custom_tab_product SET tmdtab_id = '" . (int) $tmdtab_id . "',product_id='" . $product_id . "'");
			}
		}
	
	// 20-12-2018
		if (isset($data['customer_group'])) {
			foreach ($data['customer_group'] as $customer_group_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "tmd_custom_tab_customer_group SET tmdtab_id = '" . (int)$tmdtab_id . "', customer_group_id = '" . (int)$customer_group_id . "'");
			}
		}
		if (isset($data['tmdtab_store'])) {
			foreach ($data['tmdtab_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "tmd_custom_tab_store SET tmdtab_id = '" . (int)$tmdtab_id . "', store_id = '" . (int)$store_id . "'");
			}
		}
		// 20-12-2018
	
		return $tmdtab_id;
	}
	public function gettmdtabs($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "tmd_custom_tab t LEFT JOIN " . DB_PREFIX . "tmd_custom_tab_description td ON (t.tmdtab_id = td.tmdtab_id) WHERE td.language_id = '" . (int)$this->config->get('config_language_id') . "'";
		$sort_data = array(
				'title',
				'sort_order'
			);

			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
				$sql .= " ORDER BY " . $data['sort'];
			} else {
				$sql .= " ORDER BY sort_order";
			}

			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}

			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}

				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}

			$query = $this->db->query($sql);

			return $query->rows;
	}
	

	public function gettmdtab($tmdtab_id){
		$sql="select * from " . DB_PREFIX . "tmd_custom_tab t left join " . DB_PREFIX . "tmd_custom_tab_description td on t.tmdtab_id=td.tmdtab_id where td.language_id='" . $this->config->get('config_language_id') . "' and t.tmdtab_id = '" .$tmdtab_id ."'";
		$query = $this->db->query($sql);
		return $query->row;
	}
	
	public function gettmdtabDescriptions($tmdtab_id) {
		$information_description_data = array();
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "tmd_custom_tab_description WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");
		foreach ($query->rows as $result) {
			$information_description_data[$result['language_id']] = array(
				'title'            => $result['title'],
				'description'      => $result['description'],

			);
		}
		return $information_description_data;
	}
	
	//start setting tab @ vikas 20-12-2018
	public function getTmdTabStore($tmdtab_id) {
		$group_auto_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "tmd_custom_tab_store WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");

		foreach ($query->rows as $result) {
			$group_auto_data[] = $result['store_id'];
		}

		return $group_auto_data;
	}

	public function getTmdTabCustomerGroup($tmdtab_id) {
		$change_customer_group_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "tmd_custom_tab_customer_group WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");

		foreach ($query->rows as $result) {
			$change_customer_group_data[] = $result['customer_group_id'];
		}

		return $change_customer_group_data;
	}
	//end setting tab @ vikas 20-12-2018
	
	public function gettmdchatcategoryid($tmdtab_id){
		$category_id = array();
		$sql   = "select * from " . DB_PREFIX . "tmd_custom_tab_category where tmdtab_id='" . $tmdtab_id . "'";
		$query = $this->db->query($sql);
		foreach ($query->rows as $result){
			$category_id[] = $result['category_id'];
		}
		return $category_id;
	}
	
		public function deletetmdtab($tmdtab_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "tmd_custom_tab WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "tmd_custom_tab_description WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");
		//start setting tab @ vikas 20-12-2018
		$this->db->query("DELETE FROM " . DB_PREFIX . "tmd_custom_tab_customer_group WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "tmd_custom_tab_store WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");
		//end setting tab @ vikas 20-12-2018
	
	}
	
	
	
	public function gettmdchatmanufacturer($tmdtab_id){
		$manufacturer_id = array();
		$sql   = "select * from " . DB_PREFIX . "tmd_custom_tab_manufacturer where tmdtab_id='" . $tmdtab_id . "'";
		$query = $this->db->query($sql);
		foreach ($query->rows as $result){
			$manufacturer_id[] = $result['manufacturer_id'];
		}
		return $manufacturer_id;
	}

	public function gettmdchatproduct($tmdtab_id){
		$product_id = array();
		$sql   = "select * from " . DB_PREFIX . "tmd_custom_tab_product where tmdtab_id='" . $tmdtab_id . "'";
		$query = $this->db->query($sql);
		foreach ($query->rows as $result){
			$product_id[] = $result['product_id'];
		}
		return $product_id;
	}
	public function getTotaltmdtab() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "tmd_custom_tab");

		return $query->row['total'];
	}
	
	public function edittmdtab($tmdtab_id, $data) {
		$device='';

			if(isset($data['device'])){

				$device=serialize($data['device']);

			}
		$this->db->query("UPDATE " . DB_PREFIX . "tmd_custom_tab SET sort_order = '" . (int)$data['sort_order'] . "', status = '" . (int)$data['status'] . "',device = '" .$device . "',customer = '" . (int)$data['customer'] . "',date_modified=now() WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "tmd_custom_tab_description WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");
		foreach ($data['tmdtab_description'] as $language_id => $value) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "tmd_custom_tab_description SET tmdtab_id = '" . (int)$tmdtab_id . "', language_id = '" . (int)$language_id . "', title = '" . $this->db->escape($value['title']) . "',description = '" . $this->db->escape($value['description']) . "',date_modified=now()");
		}
		$this->db->query("DELETE FROM " . DB_PREFIX . "tmd_custom_tab_category WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");
		if (isset($data['category_id'])){
			foreach ($data['category_id'] as $category_id){
				$sql = $this->db->query("INSERT INTO " . DB_PREFIX . "tmd_custom_tab_category SET tmdtab_id = '" . (int) $tmdtab_id . "',category_id='" . $category_id . "'");
			}
		}
		$this->db->query("DELETE FROM " . DB_PREFIX . "tmd_custom_tab_manufacturer WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");

		if (isset($data['manufacturer_id'])){
			foreach ($data['manufacturer_id'] as $manufacturer_id){
				$sql = $this->db->query("INSERT INTO " . DB_PREFIX . "tmd_custom_tab_manufacturer SET tmdtab_id = '" . (int) $tmdtab_id . "',manufacturer_id='" . $manufacturer_id . "'");
			}
		}
		$this->db->query("DELETE FROM " . DB_PREFIX . "tmd_custom_tab_product WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");
		if (isset($data['product_id'])){
			foreach ($data['product_id'] as $product_id){
				$sql = $this->db->query("INSERT INTO " . DB_PREFIX . "tmd_custom_tab_product SET tmdtab_id = '" . (int) $tmdtab_id . "',product_id='" . $product_id . "'");
			}
		}
		
		// 20-12-2018
		$this->db->query("DELETE FROM " . DB_PREFIX . "tmd_custom_tab_store WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");

		if (isset($data['tmdtab_store'])) {
			foreach ($data['tmdtab_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "tmd_custom_tab_store SET tmdtab_id = '" . (int)$tmdtab_id . "', store_id = '" . (int)$store_id . "'");
			}
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "tmd_custom_tab_customer_group WHERE tmdtab_id = '" . (int)$tmdtab_id . "'");

		if (isset($data['customer_group'])) {
			foreach ($data['customer_group'] as $customer_group_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "tmd_custom_tab_customer_group SET tmdtab_id = '" . (int)$tmdtab_id . "', customer_group_id = '" . (int)$customer_group_id . "'");
			}
		}
		// 20-12-2018

	}

	
}