<?php

/**
 * @license Commercial
 * @author info@ocdemo.eu
 * 
 * All code within this file is copyright OC Mega Extensions.
 * You may not copy or reuse code within this file without written permission. 
 */

abstract class ControllerModuleMRewardPointsAbstract extends Controller {
	
	protected $_name = 'mreward_points';
	
	protected $error = array();
	
	protected $data = array();

	public function __construct($registry) {
		parent::__construct( $registry );
		
		$this->load->model( $this->module_path() );
		
		// language
		$this->data = array_merge( $this->data, $this->language->load( $this->module_path() ) );
		
		// breadcrumbs
		$this->data['breadcrumbs'] = array(
			array(
				'text' => $this->language->get( 'text_home' ),
				'href' => $this->url->link( version_compare( VERSION, '2.3.0.0', '>=' ) ? 'common/dashboard' : 'common/home', $this->user_token(), true ),
				'separator' => false
			),
			array(
				'text' => $this->language->get( 'text_modules' ),
				'href' => $this->url->link( 
					( version_compare( VERSION, '3', '>=' ) ? 'marketplace/' : 'extension/' ) . ( version_compare( VERSION, '2.3.0.0', '>=' ) ? 'extension' : 'module' ), $this->user_token(), 
					true 
				),
				'separator' => false
			),
			array(
				'text' => $this->language->get( 'heading_title' ),
				'href' => $this->url->link( $this->module_path() , $this->user_token(), true ),
				'separator' => ' :: '
			)
		);
	}
	
	protected function user_token() {
		if( version_compare( VERSION, '3', '>=' ) ) {
			return 'user_token=' . $this->session->data['user_token'];
		}
		
		return 'token=' . $this->session->data['token'];
	}
	
	protected function module_path( $p = null, $n = true ) {
		/* @var $path string */
		$path = 'module';

		if( $n ) {
			$path .= '/' . $this->_name;
		}
		
		if( version_compare( VERSION, '3', '>=' ) ) {
			$path = 'extension/' . $path;
		}
		
		return $path . ( $p ? '/' . $p : '' );
	}
	
	protected function module_model() {
		return 'model_' . str_replace( '/', '_', $this->module_path() );
	}
	
	protected function view_path( $view ) {
		return $this->module_path( $view ) . ( version_compare( VERSION, '3', '>=' ) ? '' : '.tpl' );
	}

	protected function render( $view ) {		
		// current tab
		$this->data['tab_active'] = $view;
		$this->data['heading_panel_title'] = $this->language->get( 'text_edit' );
		
		$this->data['_name'] = $this->_name;
		
		// tab's links
		$this->data['tab_generator'] = $this->url->link( $this->module_path() , $this->user_token(), true );
		$this->data['tab_settings_link'] = $this->url->link( $this->module_path( 'settings' ), $this->user_token(), true );
		$this->data['tab_reminder_link'] = $this->url->link( $this->module_path( 'reminder' ), $this->user_token(), true );
		$this->data['tab_reminder_p_link'] = $this->url->link( $this->module_path( 'expiry_reminder' ), $this->user_token(), true );
		$this->data['tab_about_link'] = $this->url->link( $this->module_path( 'about' ), $this->user_token(), true );
	
		$this->data['action_back'] = $this->url->link( 
			( version_compare( VERSION, '3', '>=' ) ? 'marketplace/' : 'extension/' ) . ( version_compare( VERSION, '2.3.0.0', '>=' ) ? 'extension' : 'module' ), $this->user_token() . '&type=module', 
			true 
		);
		
		$this->_messages();
		
		if( !$this->config->get( $this->_name.'_installed' ) ) {
			$this->install();
		}
		
		$curr_ver = $this->config->get( $this->_name.'_version' );
		
		// install/update
		if( !$curr_ver || version_compare( $curr_ver, $this->_version, '<' ) ) {
			$this->load->model( 'setting/setting' );

			$this->model_setting_setting->editSetting( $this->_name.'_version', array(
				$this->_name.'_version' => $this->_version
			));

			if( $curr_ver ) {
				$this->{$this->module_model()}->update( false, $curr_ver, $this->_version );
				
				$this->session->data['success'] = $this->language->get( 'success_updated' );

				$this->response->redirect( $this->url->link( $this->module_path( 'about' ), $this->user_token() . '&refresh_ocmod_cache=1', true ) );
			}
		}
		
		// title
		$this->document->setTitle( $this->language->get( 'heading_title' ) );
		
		$this->data['back'] = $this->url->link(
			( version_compare( VERSION, '3', '>=' ) ? 'marketplace' : 'extension' ) . ( version_compare( VERSION, '2.3.0.0', '>=' ) ? 'extension' : 'module' ), $this->user_token(), 
			true
		);

		$this->data['header'] = $this->load->controller( 'common/header' );
		$this->data['column_left'] = $this->load->controller( 'common/column_left' );
		$this->data['footer'] = $this->load->controller( 'common/footer' );
		
		if( ! empty( $this->request->get['refresh_ocmod_cache'] ) ) {
			$this->data['refresh_ocmod_cache'] = json_encode(array(
				$this->url->link( ( version_compare( VERSION, '3', '>=' ) ? 'marketplace' : 'extension' ) . '/modification/clear', $this->user_token(), 'SSL'),
				$this->url->link( ( version_compare( VERSION, '3', '>=' ) ? 'marketplace' : 'extension' ) . '/modification/refresh', $this->user_token(), 'SSL')
			));
		}
		
		$this->response->setOutput( $this->load->view( $this->view_path( $view ), $this->data ) );
	}
	
	public function index() {
		if ( ($this->request->server['REQUEST_METHOD'] == 'POST') && $this->checkPermission() ) {
			$this->load->model('setting/setting');

			$this->request->post['rewards']['points']	= (float) $this->request->post['rewards']['points'];
			$this->request->post['rewards']['amount']	= (float) $this->request->post['rewards']['amount'];

			foreach( $this->request->post['rewards']['groups'] as $k => $v ) {
				$this->request->post['rewards']['groups'][$k] = (float) $v;
			}

			/**
			 * Save settings
			 */
			$this->model_setting_setting->editSetting( $this->_name.'_generator', array(
				$this->_name.'_generator' => $this->request->post['rewards']
			));

			$this->session->data['success'] = $this->language->get('text_success');

			/**
			 * Generate points for orders 
			 */
			if( ! empty( $this->request->post['generate'] ) ) {
				$this->response->redirect($this->url->link( $this->module_path('generator'), $this->user_token(), true));
			}

			$this->response->redirect($this->url->link( $this->module_path(), $this->user_token(), true));
		}
		
		if(version_compare( VERSION, '2.1.0.0', '>=' )){
			$this->load->model('customer/customer_group');
			$this->data['groups'] = $this->model_customer_customer_group->getCustomerGroups(array());
		}else{
			$this->load->model('sale/customer_group');
			$this->data['groups'] = $this->model_sale_customer_group->getCustomerGroups();
		}
		
		$this->load->model('localisation/order_status');
		
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		$this->data['action_save'] = $this->url->link( $this->module_path(), $this->user_token(), true);
		
		$this->data[(version_compare(VERSION, '3', '>=')?'user_':'').'token'] = $this->user_token();
		$this->data['currency'] = $this->config->get( 'config_currency' );
		
		$this->data['settings'] = $this->config->get( $this->_name.'_generator' );
						
		$this->render('index');
	}
	
	public function generator() {
		if( class_exists( 'VQMod' ) ) {
			require_once VQMod::modCheck( modification( DIR_SYSTEM . 'library/mreward_points/helper.php' ) );
		} else {
			require_once modification( DIR_SYSTEM . 'library/mreward_points/helper.php' );
		}
		
		if( $this->request->server['REQUEST_METHOD'] == 'POST' && $this->checkPermission() ) {
			$this->response->addHeader('Content-Type: application/json');
			return $this->response->setOutput( json_encode( MRewardPointsHelper::make( $this )->generatePoints() ) );
		}
		
		$this->data['return_action'] = $this->url->link( $this->module_path(), $this->user_token(), true);
		$this->data['generator_action'] = $this->url->link( $this->module_path('generator'), $this->user_token(), true);
		
		$this->render('generator');
	}
	
	public function settings() {
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->checkPermission()) {
			$this->load->model('setting/setting');
			
			if(empty($this->request->post['settings']['order_status_add'])){
				$this->request->post['settings']['order_status_add'] = array();
			}
		
			$this->model_setting_setting->editSetting( $this->_name.'_settings', array( $this->_name.'_settings' => $this->request->post['settings']));
			
			if( empty($this->request->post['settings']['order_status_remove']) ){
				$this->request->post['settings']['order_status_remove'] = array();
			}
			
			$this->model_setting_setting->editSetting( $this->_name.'_bonuses', array(  $this->_name.'_bonuses' => $this->request->post['bonuses'] ));
			
			$this->session->data['success'] = $this->language->get('text_success');
			$this->response->redirect($this->url->link( $this->module_path('settings'), $this->user_token(), true));
		}
		
		if( $this->error ) {
			$this->_setErrors($this->error);
		}

		$this->load->model('localisation/order_status');
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$this->data['settings']	 = $this->config->get( $this->_name.'_settings' );
		
		$this->load->model('localisation/language');
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		$this->data['bonuses']	 = $this->config->get( $this->_name.'_bonuses' );

		$this->data['action_save']	 = $this->url->link( $this->module_path('settings'), $this->user_token(), true);

		$this->render('settings');
	}

	public function expiry_reminder() {			
		if ( ($this->request->server['REQUEST_METHOD'] == 'POST') && $this->checkPermission() ) {
			$this->load->model('setting/setting');
			
			if( ! empty( $this->request->post['rewards']['for_orders_created_after'] ) ) {
				if( ! preg_match( '/^\d\d\d\d-\d\d-\d\d$/', $this->request->post['rewards']['for_orders_created_after'] ) ) {
					$this->request->post['rewards']['for_orders_created_after'] = '';
				}
			}
			
			/**
			 * Save settings
			 */
			$this->model_setting_setting->editSetting( $this->_name.'_expiry_reminder', array(
				$this->_name.'_expiry_reminder' => $this->request->post['rewards']
			));
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$this->response->redirect($this->url->link( $this->module_path('expiry_reminder'), $this->user_token(), true));
		}
		
		$this->load->model('localisation/language');
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		
		$this->data['action_save'] = $this->url->link($this->module_path('expiry_reminder'), $this->user_token(), true);
		$this->data['action_sent_test_email'] = $this->url->link($this->module_path('sendTestEmailPoints'), $this->user_token(), true);
		
		$this->data['mrp_settings'] = (array) $this->config->get( $this->_name.'_expiry_reminder' );
		
		if( empty( $this->data['mrp_settings']['secret_code'] ) ) {
			$this->data['mrp_settings']['secret_code'] = substr( md5( microtime() ), 0, 5 );
		}
		
		$this->data['HTTP_URL'] = defined( 'HTTPS_CATALOG' ) ? HTTPS_CATALOG : ( defined( 'HTTP_CATALOG' ) ? HTTP_CATALOG : 'http://YOUR-STORE-DOMAIN/' );
		$this->data['cron_info'] = sprintf( $this->language->get('text_cron_info'), $this->data['HTTP_URL'] . 'index.php?route='.$this->module_path('mrp_cron/cron_reward_points', false).'&code=<span class="secret_code"></span>', $this->data['HTTP_URL'] . 'index.php?route='.$this->module_path('mrp_cron/cron_reward_points', false).'&code=<span class="secret_code"></span>' );
		
		$this->render('expiry_reminder');
	}
	
	public function sendTestEmailPoints() {
		$json = array();
		
		$this->language->load( $this->module_path() );
		$settings = $this->config->get( $this->_name.'_expiry_reminder' );
		
		$check_content = false;
		
		if( ! empty( $settings['reminder_content'] ) ) {
			$check_content = true;
			
			foreach ($settings['reminder_content'] as $check_lang){
				if( empty($check_lang['reminder_title']) || empty($check_lang['reminder_title']) ) {
					$check_content = false;
				}
			}
		}
		
		if( isset($this->request->get['action']) && !empty($this->request->post['email']) && $check_content) {
			
			$this->load->model('module/' . $this->_name . '_plus');
			
			$this->{$this->module_model()}->sendTestEmail($this->request->post['email'], 'points');
			
			$json['success'] = 'success';
			$json['send_confirmation'] = $this->request->post['email'];
			$json['send_confirmation_text'] = $this->language->get('text_success_test_email_sent');
		}else{
			$json['success'] = 'failed';
			$json['send_confirmation_text'] = !$check_content ? $this->language->get('error_content') : $this->language->get('text_success_test_email_error');
		}
		
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function reminder() {		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->checkPermission()) {
			$this->load->model('setting/setting');
			
			if( ! empty( $this->request->post['reminder']['for_orders_created_after'] ) ) {
				if( ! preg_match( '/^\d\d\d\d-\d\d-\d\d$/', $this->request->post['reminder']['for_orders_created_after'] ) ) {
					$this->request->post['reminder']['for_orders_created_after'] = '';
				}
			}

			$this->model_setting_setting->editSetting( $this->_name.'_reminder', array( $this->_name.'_reminder' => $this->request->post['reminder']));
			
			$this->session->data['success'] = $this->language->get('text_success');
			$this->response->redirect($this->url->link( $this->module_path('reminder'), $this->user_token(), true));
		}
		
		if( $this->error ) {
			$this->_setErrors($this->error);
		}

		$this->load->model('localisation/order_status');
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$this->load->model('localisation/language');
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		
		$this->data['pending_reminders'] = $this->{$this->module_model()}->pendingReminders();
 
		$this->data['reminder']	 = (array) $this->config->get( $this->_name.'_reminder' );
		
		if( empty( $this->data['reminder']['secret_code'] ) ) {
			$this->data['reminder']['secret_code'] = substr( md5( microtime() ), 0, 5 );
		}

		$this->data['action_save']	 = $this->url->link($this->module_path('reminder'), $this->user_token(), true);
		$this->data['action_sent_test_email'] = $this->url->link($this->module_path('sendTestEmail'), $this->user_token(), true);
		$this->data['action_check_pending_reminders'] = $this->url->link($this->module_path('pendingReminders'), $this->user_token(), true);
		
		$this->data['HTTP_URL'] = defined( 'HTTPS_CATALOG' ) ? HTTPS_CATALOG : ( defined( 'HTTP_CATALOG' ) ? HTTP_CATALOG : 'http://YOUR-STORE-DOMAIN/' );
		$this->data['cron_info'] = sprintf( $this->language->get('text_cron_info'), $this->data['HTTP_URL'] . 'index.php?route='.$this->module_path('mrp_cron', false).'&code=<span class="secret_code"></span>', $this->data['HTTP_URL'] . 'index.php?route='.$this->module_path('mrp_cron', false).'&code=<span class="secret_code"></span>' );
				
		$this->render('reminder');
	}
	
	public function pendingReminders() {
		$this->load->model( $this->module_path() );

		$json = array();
		$json['pending_reminders'] =  $this->{$this->module_model()}->pendingReminders();
		$json['success'] = 'success';
						
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function sendTestEmail() {
		$json = array();
		
		$this->language->load( $this->module_path() );
		$settings = $this->config->get( $this->_name.'_reminder' );
		
		$check_content = false;
		
		if( ! empty( $settings['reminder_content'] ) ) {
			$check_content = true;
			
			foreach ($settings['reminder_content'] as $check_lang){
				if( empty($check_lang['reminder_title']) || empty($check_lang['reminder_title']) ) {
					$check_content = false;
				}
			}
		}
		
		if( isset($this->request->get['action']) && !empty($this->request->post['email']) && $check_content ) {			
			$this->{$this->module_model()}->sendTestEmail($this->request->post['email'], 'review');
			
			$json['success'] = 'success';
			$json['send_confirmation'] = $this->request->post['email'];
			$json['send_confirmation_text'] = $this->language->get('text_success_test_email_sent');
		}else{
			$json['success'] = 'failed';
			$json['send_confirmation_text'] = !$check_content ? $this->language->get('error_content') : $this->language->get('text_success_test_email_error');
		}
		
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function about() {			
		$this->data['ext_version'] = $this->_version;

		$this->render('about');
	}
	
	protected function _messages() {
		// notifications
		if( isset( $this->session->data['success'] ) ) {
			$this->data['_success'] = $this->session->data['success'];

			unset( $this->session->data['success'] );
		}

		if( isset( $this->session->data['error'] ) ) {
			$this->_setErrors( array(
				'warning' => $this->session->data['error']
			) );

			unset( $this->session->data['error'] );
		}
	}
	
	/**
	 * Set errors
	 * 
	 * @param array $errors
	 */
	protected function _setErrors( $errors ) {
		foreach( $errors as $name => $default ) {
			$this->data['_error_' . $name] = $default;
		}
	}
	
	/**
	 * @return boolean
	 */
	protected function checkPermission() {
		if( !$this->hasPermission() ) {
			$this->_setErrors( array(
				'warning' => $this->language->get( 'error_permission' )
			) );

			return false;
		}
		return true;
	}
	
	/**
	 * Check permissions
	 * 
	 * @return boolean
	 */
	protected function hasPermission() {
		if( ! $this->user->hasPermission('modify', $this->module_path()) ) {
			return false;
		}
		
		return true;
	}
	
	/**
	 * Installation
	 */
	public function install() {
		$this->language->load( $this->module_path() );
		
		// load models
		$this->load->model( ( version_compare( VERSION, '3', '>=' ) ? 'setting' : 'extension' ) . '/extension' );
		$this->load->model( 'setting/setting' );
		$this->load->model( $this->module_path() );
		$this->load->model( 'localisation/language' );

		if($this->checkPermission()){
			$this->{$this->module_model()}->install();

			/**
			 * Check if the extension is on the list
			 */
			if( ! in_array( $this->_name, $this->{'model_' . ( version_compare( VERSION, '3', '>=' ) ? 'setting' : 'extension' ) . '_extension'}->getInstalled( 'module' ) ) ) {
				$this->{'model_' . ( version_compare( VERSION, '3', '>=' ) ? 'setting' : 'extension' ) . '_extension'}->install( 'module', $this->_name );
			}

			/**
			 * Check if is duplicate
			 */
			$idx = 0;
			foreach( $this->db->query( "SELECT * FROM " . DB_PREFIX . "extension WHERE code='" . $this->_name . "' AND type='module'" )->rows as $row ) {
				if( $idx ) {
					$this->db->query( "DELETE FROM " . DB_PREFIX . "extension WHERE extension_id='" . (int) $row['extension_id'] . "'" );
				}
				$idx++;
			}

			$this->model_setting_setting->editSetting( $this->_name . '_installed', array(
				$this->_name . '_installed' => '1'
			) );

			$this->{$this->module_model()}->update( true );

			$this->session->data['success'] = $this->language->get( 'success_install' );
			
			if( version_compare( VERSION, '3', '<' ) ) {
				$this->response->redirect( $this->url->link( $this->module_path('about'), $this->user_token(), true ) );
			}
		}else{
			$this->session->data['success'] = $this->language->get( 'error_permission' );
			
			if( version_compare( VERSION, '3', '<' ) ) {
				if(version_compare( VERSION, '2.3.0.0', '>=' )){
					$this->response->redirect( $this->url->link( 'extension/extension', $this->user_token(), true ) );
				}else{
					$this->response->redirect( $this->url->link( 'extension/module', $this->user_token(), true ) );
				}
			}
		}
	}
	
	/**
	 * Uninstall
	 */
	public function uninstall() {
		$this->language->load( $this->module_path() );

		/**
		 * Check if extension is on the list
		 */
		$this->load->model( ( version_compare( VERSION, '3', '>=' ) ? 'setting' : 'extension' ) . '/extension' );
		$this->load->model( 'setting/setting' );
		$this->load->model( 'module/' . $this->_name );
		$this->load->model( 'setting/setting' );

		if($this->checkPermission()){
			$this->{$this->module_model()}->uninstall();

			if( in_array( $this->_name, $this->{'model_' . ( version_compare( VERSION, '3', '>=' ) ? 'setting' : 'extension' ) . '_extension'}->getInstalled( 'module' ) ) ) {
				$this->{'model_' . ( version_compare( VERSION, '3', '>=' ) ? 'setting' : 'extension' ) . '_extension'}->uninstall( 'module', $this->_name );
			}
			
			if( empty( $this->request->get['error'] ) ) {
				$this->session->data['success'] = $this->language->get( 'success_uninstall' );
			}
			
			if( version_compare( VERSION, '3', '<' ) ) {
				if(version_compare( VERSION, '2.3.0.0', '>=' )){
					$this->response->redirect( $this->url->link( 'extension/extension', $this->user_token(), true ) );
				}else{
					$this->response->redirect( $this->url->link( 'extension/module', $this->user_token(), true ) );
				}
			}
		}else{
			$this->session->data['success'] = $this->language->get( 'error_permission' );
			
			if( version_compare( VERSION, '3', '<' ) ) {
				$this->response->redirect( $this->url->link( 'module/'. $this->_name . '/about', $this->user_token(), true ) );
			}
		}

	}
}