<?php
class ModelExtensionModuleSmm extends Model {
    use OCM\Traits\Front\Address;
    use OCM\Traits\Front\Common_params;
    use OCM\Traits\Front\Product;
    use OCM\Traits\Front\Validator;
    use OCM\Traits\Front\Crucify;
    use OCM\Traits\Front\Util;
    private $mtype;
    private $_cart_data;
    private $smms;
    public function __construct($registry) {
        parent::__construct($registry);
        $this->registry = $registry;
        $this->ocm = ($ocm = $this->registry->get('ocm_front')) ? $ocm : new OCM\Front($this->registry);
        $this->mtype = 'module'; //basically it is a module
        $cart_products = $this->cart->getProducts();
        $this->smms = $this->getShippings();
        $_cart_data = $this->getProductProfile($cart_products, $this->smms['xmeta']);
        if ($this->smms['xmeta']['grand'] || ($this->smms['xmeta']['coupon'])) {
            $total_mods = array(array('code' => 'coupon'));
            $xtotals = $this->ocm->getTotals($_cart_data['tax_data']);
            foreach ($xtotals['totals'] as $single) {
                if ($single['code'] == 'coupon') {
                    $_cart_data['coupon'] = $single['value'];
                }
            }
            $_cart_data['grand'] = $xtotals['total'];
        }
        $shipping_cost = isset($this->session->data['shipping_method']['cost']) ? (float)$this->session->data['shipping_method']['cost'] : 0;
        if (isset($this->session->data['default']['shipping_method']['cost'])) $shipping_cost = $this->session->data['default']['shipping_method']['cost'];
        $_cart_data['sub_coupon']     = $_cart_data['sub'] + $shipping_cost;
        $_cart_data['total_coupon']   = $_cart_data['total'] + $shipping_cost;
        $_cart_data['sub_shipping']   = $_cart_data['sub'] + $_cart_data['coupon'];
        $_cart_data['total_shipping'] = $_cart_data['total'] + $_cart_data['coupon'];
        $_cart_data['grand']          = $_cart_data['grand'];
        $this->_cart_data = $_cart_data;
    }
    public function verifyMethod($code, $quote, $address) {
        $address = $this->_replenishAddress($address);
        $compare_with = $this->_getCommonParams($address);

        $smm_debug = $this->ocm->getConfig('smm_debug', $this->mtype);
        $smm_status = $this->ocm->getConfig('smm_status', $this->mtype);

        if (!$smm_status) {
            return $quote;
        }
        $smms = $this->smms;
        $xmethods = $smms['xmethods'];
        $xmeta = $smms['xmeta'];

        $geo_ids = array();
        if ($xmeta['geo']) {
            $geo_rows = $this->db->query("SELECT geo_zone_id FROM " . DB_PREFIX . "zone_to_geo_zone WHERE country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')")->rows; 
            foreach ($geo_rows as $geo_row) {
                $geo_ids[] = $geo_row['geo_zone_id'];
            }
        }

        $_cart_data = $this->_cart_data;
        $compare_with['status'] = false;
        $compare_with['geo'] = $this->geo_ids;
        $compare_with['product'] = $_cart_data['product'];
        $compare_with['category'] = $_cart_data['category'];
        $compare_with['manufacturer'] = $_cart_data['manufacturer'];
        $compare_with['option'] = $_cart_data['option'];
        $compare_with['attribute'] = $_cart_data['attribute'];
        $compare_with['total'] = $_cart_data['total'];
        $compare_with['weight'] = $_cart_data['weight'];
        $compare_with['quantity'] = $_cart_data['quantity'];
        $compare_with['stock_status'] = $_cart_data['stock_status'];
        $compare_with['out_of_stock'] = !!$_cart_data['out_of_stock'];

        $debugging = array();
        foreach($quote as $_code => $_data) {
            $key = $_code;
            // update key if shipping is usps as admin and site key not same
            if ($code == 'usps') {
                $key = (isset($xmethods[$code . '.international_' . $key]) ? 'international_' : 'domestic_') . $key;
            }
            $_key = $code . '.' . $key;
            if (!isset($xmethods[$key]) && !isset($xmethods[$_key]) && !isset($xmethods[$code])) {
                continue;
            }
            if (isset($xmethods[$key])) {
                $smm = $xmethods[$key];
            } else if (isset($xmethods[$_key])) {
                $smm = $xmethods[$_key];
            } else {
               $smm = $xmethods[$code];
            }
            $rules = $smm['rules'];
            $debugging_message = array();

            if (isset($rules['total_range'])) {
                $compare_with[$smm['total_type']] = $_cart_data[$smm['total_type']];
            }
            $alive_or_dead = $this->_crucify($rules, $compare_with);
            if (!$alive_or_dead['status']) {
                unset($quote[$_code]);
                $debugging_message = $alive_or_dead['debugging'];
                $debugging[] = array('name' => $code, 'filter' => $debugging_message,'index' => '');
            }
        }
        if ($smm_debug) {
           $this->ocm->writeLog($debugging, 'smm');
        }
        return $quote;
    }
    // for OC 2.1.x i.e for ocmod 
    public function getMethods($methods) {
        if (!$methods) return $methods;
        $address = array();
        foreach ($methods as $code =>&$method) {
            $quote = $method['quote'];
            $quote = $this->verifyMethod($code, $quote, $address);
            if ($quote) {
                $method['quote'] = $quote;
            } else {
                unset($methods[$code]);
            }
        }
        return $methods;
    }
    private function getShippings() {
        $smm = $this->cache->get('ocm.smm');
        if (!$smm) {
            $prefix = VERSION >= '3.0.0.0' ? 'shipping_' : '';
            $xmethods = array();
            $xmeta = array(
                'grand'          => false,
                'coupon'         => false,
                'geo'            => false,
                'product_query'  => false,
                'category_query' => false
            );
            $smm_rows = $this->db->query("SELECT * FROM `" . DB_PREFIX . "smm` order by `code` asc")->rows;
            foreach($smm_rows as $smm_row) {
                $code = str_replace('__', '.', $smm_row['code']);
                $component =  explode('.', $code);
                $shipping = array_shift($component);
                $method_data = $smm_row['method_data'];
                $method_data = json_decode($method_data, true);
                /* cache only valid shipping */
                if ($method_data && is_array($method_data) && $this->ocm->getConfig($shipping . '_status', 'shipping')) {
                    $method_data =  $this->_resetEmptyRule($method_data);
                    $rules = $this->_findValidRules($method_data);
                    $xmethods[$code] = array(
                       'code'  => $code,
                       'rules' => $rules,
                       'total_type' => $method_data['total_type']
                    );
                    if ($method_data['geo_zone_all'] != 1) {
                        $xmeta['geo'] = true;
                    }
                    if ($method_data['total_type'] == 'sub_coupon' || $method_data['total_type'] == 'total_coupon') {
                        $xmeta['coupon'] = true;
                    }
                    if ($method_data['total_type'] == 'grand') {
                        $xmeta['grand'] = true;
                    }
                    if ((int)$method_data['manufacturer_rule'] > 1 || $method_data['stock_status_all'] != 1) {
                        $xmeta['product_query'] = true;
                    }
                    if ((int)$method_data['category'] > 1) {
                        $xmeta['category_query'] = true;
                    }
                }
            }
            $smm = array('xmeta' => $xmeta, 'xmethods' => $xmethods);
            $this->cache->set('ocm.smm', $smm);
        }
        return $smm;
    }

    private function _resetEmptyRule($data) {
        $rules = array(
            'store'         => 'store_all',
            'country'       => 'country_all', 
            'geo_zone'      => 'geo_zone_all',
            'zone'          => 'zone_all',
            'currency'      => 'currency_all',
            'customer_group' => 'customer_group_all',
            'stock_status'   => 'stock_status_all',
            'city'           => 'city_all',
            'postal'         => 'postal_all',
            'coupon'         => 'coupon_all',
            'product_category' => 'category',
            'product_product'   => 'product',
            'product_option'    => 'option',
            'product_attribute' => 'attribute',
            'manufacturer'      => 'manufacturer_rule'
        );

        foreach ($rules as $key => $value) {
            if (!isset($data[$value])) {
                $data[$value] = '';
            }
            if (!isset($data[$key]) || !$data[$key]) {
                $data[$value] = 1;
            }
            /* Make product field empty if all was chosen*/
            if ($data[$value] < 2 && in_array($key, array('product_category', 'product_product', 'manufacturer'))) {
                $data[$key] = array();
            }
        }

        /* reset delimitter to comma */
        $fields = array(
            'city',
            'coupon',
            'postal'
        );
        foreach ($fields as $field) {
            if ($data[$field]) {
                $data[$field] = str_replace(PHP_EOL, ',', $data[$field]);
            }
        }
        /* checkboxes */
        if (!isset($data['out_of_stock'])) $data['out_of_stock'] = '';
        /* Reset other */
        if (!isset($data['days'])) $data['days'] = array();
        if (!empty($data['total_start']) && empty($data['total_end'])) $data['total_end'] = PHP_INT_MAX;
        if (!empty($data['weight_start']) && empty($data['weight_end'])) $data['weight_end'] = PHP_INT_MAX;
        if (!empty($data['quantity_start']) && empty($data['quantity_end'])) $data['quantity_end'] = PHP_INT_MAX;
        return $data;
    }

    private function _findValidRules($data) {
        $rules = array();
        if ($data['store_all'] != 1) {
            $rules['store'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => false,
                'value' => $data['store'],
                'compare_with' => 'store_id',
                'false_value' => false
            );
        }
        if ($data['geo_zone_all'] != 1) {
            $rules['geo_zone'] = array(
                'type' => 'intersect',
                'product_rule' => false,
                'address_rule' => true,
                'value' => $data['geo_zone'],
                'compare_with' => 'geo',
                'false_value' => false
            );
        }
        if ($data['country_all'] != 1) {
            $rules['country'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => true,
                'value' => $data['country'],
                'compare_with' => 'country_id',
                'false_value' => false
            );
        }
        if ($data['currency_all'] != 1) {
            $rules['currency'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => false,
                'value' => $data['currency'],
                'compare_with' => 'currency_id',
                'false_value' => false
            );
        }
        if ($data['zone_all'] != 1) {
            $rules['zone'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => true,
                'value' => $data['zone'],
                'compare_with' => 'zone_id',
                'false_value' => false
            );
        }
        if ($data['customer_group_all'] != 1) {
            $rules['customer_group'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => false,
                'value' => $data['customer_group'],
                'compare_with' => 'customer_group_id',
                'false_value' => false
            );
        }
        if ($data['stock_status_all'] != 1) {
            $rules['stock_status'] = array(
                'type' => 'intersect',
                'product_rule' => false,
                'address_rule' => false,
                'value' => $data['stock_status'],
                'compare_with' => 'stock_status',
                'false_value' => false
            );
        }
        if ($data['city_all'] != 1) {
            $false_value = ($data['city_rule'] == 'inclusive') ? false : true;
            $cities = explode(',',trim($data['city']));
            $cities = array_map('strtolower', $cities);
            $cities = array_map('trim', $cities);
            $rules['city'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => true,
                'value' => $cities,
                'compare_with' => 'city',
                'false_value' => $false_value
            );
        }
        if ($data['postal_all'] != 1) {
            $postcodes = explode(',',trim($data['postal']));
            $postcodes = array_map('trim', $postcodes);
            $rules['postal'] = array(
                'type' => 'function',
                'func' => '_validatePostal',
                'product_rule' => false,
                'address_rule' => true,
                'value' => $postcodes,
                'compare_with' => 'postcode',
                'rule_type' => $data['postal_rule'],
                'false_value' => false
            );
        }
        if ($data['coupon_all'] != 1) {
            $false_value = ($data['coupon_rule'] == 'inclusive') ? false : true;
            $coupons = explode(',',trim($data['coupon']));
            $coupons = array_map('trim', $coupons);
            $coupons = array_map('strtolower', $coupons);
            $rules['coupon'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => false,
                'value' => $coupons,
                'compare_with' => 'coupon_code',
                'false_value' => $false_value
            );
        }
        if ((int)$data['product'] > 1) {
            $rules['product'] = array(
                'type' => 'function',
                'func' => '_validateProduct',
                'product_rule' => true,
                'address_rule' => false,
                'value' => $data['product_product'],
                'compare_with' => 'product',
                'rule_type' => $data['product'],
                'false_value' => false
            );
        }
        if ((int)$data['category'] > 1) {
            $rules['category'] = array(
                'type' => 'function',
                'func' => '_validateProduct',
                'product_rule' => true,
                'address_rule' => false,
                'value' => $data['product_category'],
                'compare_with' => 'category',
                'rule_type' => $data['category'],
                'false_value' => false
            );
        }
        if ((int)$data['manufacturer_rule'] > 1) {
            $rules['manufacturer'] = array(
                'type' => 'function',
                'func' => '_validateProduct',
                'product_rule' => true,
                'address_rule' => false,
                'value' => $data['manufacturer'],
                'compare_with' => 'manufacturer',
                'rule_type' => $data['manufacturer_rule'],
                'false_value' => false
            );
        }
        if ((int)$data['option'] > 1) {
            $rules['option'] = array(
                'type' => 'function',
                'func' => '_validateProduct',
                'product_rule' => true,
                'address_rule' => false,
                'value' => $data['product_option'],
                'compare_with' => 'option',
                'rule_type' => $data['option'],
                'false_value' => false
            );
        }
        if ((int)$data['attribute'] > 1) {
            $rules['attribute'] = array(
                'type' => 'function',
                'func' => '_validateProduct',
                'product_rule' => true,
                'address_rule' => false,
                'value' => $data['product_attribute'],
                'compare_with' => 'attribute',
                'rule_type' => $data['attribute'],
                'false_value' => false
            );
        }
        if (is_array($data['days']) && $data['days'] && count($data['days']) !== 7) {
            $rules['days'] = array(
                'type' => 'in_array',
                'product_rule' => false,
                'address_rule' => false,
                'value' => $data['days'],
                'compare_with' => 'day',
                'false_value' => false
            );
        }
        if ($data['date_start'] != "" && $data['date_end']) {
            $rules['date'] = array(
                'type' => 'in_between',
                'product_rule' => false,
                'address_rule' => false,
                'start' => $data['date_start'],
                'end' => $data['date_end'],
                'compare_with' => 'date'
            );
        }
        if ($data['time_start'] != "" && $data['time_end'] != "") {
            $valid_hours = array();
            $time_start = (int)$data['time_start'];
            $time_end = (int)$data['time_end'];

            if ($time_start <= $time_end) {
               for ($i = $time_start; $i < $time_end ; $i++) { 
                  $valid_hours[] = $i;
               }
            } else {
               for ($i = 0; $i < $time_end ; $i++) { 
                  $valid_hours[] = $i;
               }
               for ($i = $time_start; $i <= 23 ; $i++) { 
                  $valid_hours[] = $i;
               }
            }
            if ($valid_hours) {
                $rules['time'] = array(
                    'type' => 'in_array',
                    'product_rule' => false,
                    'address_rule' => false,
                    'value' => $valid_hours,
                    'compare_with' => 'time',
                    'false_value' => false
                );
            }
        }
        if ($data['total_start'] != "" 
            && (float)$data['total_end']) {
                $rules['total_range'] = array(
                    'type' => 'in_between',
                    'product_rule' => false,
                    'address_rule' => false,
                    'start' => (float)$data['total_start'],
                    'end' => (float)$data['total_end'],
                    'compare_with' => $data['total_type']
                );
        }
        if ($data['weight_start'] != ""
            && (float)$data['weight_start']) {
                $rules['weight_range'] = array(
                    'type' => 'in_between',
                    'product_rule' => false,
                    'address_rule' => false,
                    'start' => (float)$data['weight_start'],
                    'end' => (float)$data['weight_end'],
                    'compare_with' => 'weight'
                );
        }
        if ($data['quantity_start'] != ""
            && (int)$data['quantity_end']) {
                $rules['qunatity_range'] = array(
                    'type' => 'in_between',
                    'product_rule' => false,
                    'address_rule' => false,
                    'start' => (int)$data['quantity_start'],
                    'end' => (int)$data['quantity_end'],
                    'compare_with' => 'quantity'
                );
        }
        if ($data['out_of_stock']) {
            $rules['out_of_stock'] = array(
                'type' => 'equal',
                'product_rule' => false,
                'address_rule' => false,
                'value' => '',
                'compare_with' => 'out_of_stock',
                'false_value' => true
            );
        }
        if (!$data['status']) {
            $rules['status'] = array(
                'type' => 'equal',
                'product_rule' => false,
                'address_rule' => false,
                'value' => '',
                'compare_with' => 'status',
                'false_value' => false
            );
        }
        return $rules;
    }
}